#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Hexagonal Tiling PracticeMod01.fsh   by   AlexWalley  
//https://www.shadertoy.com/view/...
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define FACTOR 20.

float HexDist(vec2 p, vec2 id){
    float t = iTime;
    mat2 rot = mat2(cos(t-id.x/FACTOR), -sin(t), sin(t), cos(t-id.x/FACTOR));
    p*=rot*1.3;
    p = abs(p); // Copy over first quad into all
    float c = dot(p, normalize(vec2(1,1.73)));// Dot to get correct angle
    return max(c, p.x); // Find where the vert line and angled intersect
}

vec4 HexCoords(vec2 uv){
    vec2 rep = vec2(1, 1.73);
    vec2 h = rep*0.5;
    vec2 a = mod(uv, rep)-h;
    vec2 b = mod(uv-h, rep)-h;

    
    vec2 gv;
	if(length(a) < length(b))
    	gv = a;
    else 
        gv = b;
    
    vec2 id = (uv-gv)+FACTOR;
    float y = 0.5-HexDist(gv, id);
    return vec4(gv.x, y, id.x, id.y);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
    vec2 uv = (fragCoord-0.5*iResolution.xy)/iResolution.y;
    
    vec3 col = vec3(0);
    
    uv *= FACTOR;
	vec4 hexC = HexCoords(uv);
	float t = mod(iTime, 2000.);
    col += smoothstep(0.05, 0.1, hexC.y*sin(hexC.w*hexC.z+t));
    col += smoothstep(0.2, 0.15, hexC.y);
    col += 0.5-smoothstep(0.15, 0.1, hexC.y);
    col *= (0.7+sin(((hexC.z)/3.)+iTime)*0.3)*vec3(0.4, 0.7, 1.0);
    col += vec3(0.3, 0.4, 0.8)*0.2;
	
    // Output to screen
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

